﻿//=============================================================================
// MAR_DayWindow.js
//=============================================================================

var Imported = Imported || {};
Imported.MAR_DayWindow = true;

/*:
 * @plugindesc マップ上で階数を表示するスクリプト
 * 
 * @help
 * プラグインコマンド:
 *
 *   DayWindow show
 *     日数ウィンドウを表示する。
 *
 *   DayWindow hide
 *     ウィンドウを隠す。
 *
 *   DayWindow refresh
 *     ウィンドウを更新する。
 *
 *   DayWindow elapse
 *     時間を経過させる。
 */

(function ()
{
    // プラグイン コマンド
    Game_System.prototype.isDayWindowVisible = function ()
    {
        if (this._isDayWindowVisible == null)
        {
            this._isDayWindowVisible = !$gameSwitches.value(4) && $gameSwitches.value(65);
        }

        return this._isDayWindowVisible;
    };

    Game_System.prototype.setDayWindowVisible = function (value)
    {
        this._isDayWindowVisible = value;
    };

    Game_System.prototype.shouldDayWindowRefresh = function ()
    {
        if (this._shouldDayWindowRefresh == null)
        {
            this._shouldDayWindowRefresh = false;
        }

        return this._shouldDayWindowRefresh;
    };

    Game_System.prototype.setShouldDayWindowRefresh = function (value)
    {
        this._shouldDayWindowRefresh = value;
    };

    Game_System.prototype.elapseDay = function (value, shouldReset)
    {
        var timeZone = $gameVariables.value(82);
        var day = $gameVariables.value(84);

        if (value <= 0)
        {
            return;
        }

        timeZone += value;

        var remainder = timeZone % 4;
        var quotient = timeZone / 4;

        timeZone = Math.floor(remainder);
        $gameVariables.setValue(82, timeZone);

        day += Math.floor(quotient);
        $gameVariables.setValue(84, day);

        $gameSystem.setShouldDayWindowRefresh(true);

        this.updateCommonQuest(false, shouldReset);
    };

    Game_System.prototype.nextDay = function ()
    {
        $gameVariables.setValue(82, 0);

        $gameVariables.setValue(84, $gameVariables.value(84) + 1);

        $gameSystem.setShouldDayWindowRefresh(true);

        this.updateCommonQuest(false, true);
    };

    Game_System.prototype.updateCommonQuest = function (isForce, shouldReset)
    {
        // 錬金回数クリア
        if (shouldReset)
        {
            $gameVariables.setValue(85, 0);
            $gameSwitches.setValue(11, false);
        }

        var day = $gameVariables.value(84);
        var updateDay = $gameVariables.value(115);

        if (!isForce && day <= updateDay)
        {
            return;
        }
        $gameVariables.setValue(115, day);

        if (!isForce && !$gameSwitches.value(70))
        {
            return;
        }

        var quests;

        if (isForce && !$gameSwitches.value(70))
        {
            // 大きな壺 320
            // つるはし 390
            // 鉄のクギ 410
            // 植物油 400
            // じょうぶな紐 340
            // 大きなタル 420
            // レッドベリー 370

            quests = [320, 390, 410, 400, 340, 420, 370];
        }
        else
        {
            quests = [60, 90, 100, 110, 120, 140, 160, 170, 180, 190, 200, 210, 220, 280, 290, 300, 310, 320, 330, 340, 350, 360, 370, 380, 390, 400, 410, 420];
        }

        var count = quests.length;
        var swap, index;

        while (count)
        {
            index = Math.floor(Math.random() * count);
            --count;

            swap = quests[count];
            quests[count] = quests[index];
            quests[index] = swap;
        }

        for (var i = 0; i < 5; ++i)
        {
            $gameVariables.setValue(116 + i, -1);
        }

        for (var i = 0, j = 0, count = 116; i < quests.length; ++i)
        {
            for (j = 101; j < 111; ++j)
            {
                if ($gameVariables.value(j) == quests[i])
                {
                    break;
                }
            }

            if (j == 111)
            {
                $gameVariables.setValue(count, quests[i]);
                ++count;
            }

            if (count == 121)
            {
                break;
            }
        }
    };

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args)
    {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if (command === 'DayWindow')
        {
            switch (args[0])
            {
                case 'show':
                    $gameSystem.setDayWindowVisible(true);
                    $gameSystem.setShouldDayWindowRefresh(true);
                    break;

                case 'hide':
                    $gameSystem.setDayWindowVisible(false);
                    break;

                case 'refresh':
                    $gameSystem.setShouldDayWindowRefresh(true);
                    break;

                case 'elapse':
                    $gameSystem.elapseDay(parseInt(args[1]), true);
                    break;

                case 'elapseNotReset':
                    $gameSystem.elapseDay(parseInt(args[1]), false);
                    break;

                case 'nextDay':
                    $gameSystem.nextDay();
                    break;
            }
        }
    };

    //-----------------------------------------------------------------------------
    // DayWindow
    //
    function DayWindow()
    {
        this.initialize.apply(this, arguments);
    }

    DayWindow.prototype = Object.create(Window_Base.prototype);
    DayWindow.prototype.constructor = DayWindow;

    // 初期化
    DayWindow.prototype.initialize = function ()
    {
        var x = 16;
        var y = 8;

        var wight = 200;
        var height = 64;

        Window_Base.prototype.initialize.call(this, x, y, wight, height);

        this.openness = $gameSystem.isDayWindowVisible() ? 255 : 0;

        this.opacity = 255;
        this.contentsOpacity = 255;

        this.refresh();
    };

    // 行の高さ
    DayWindow.prototype.lineHeight = function ()
    {
        return this._lineHeight || 36;
    };

    // デフォルトのパティング
    DayWindow.prototype.standardPadding = function ()
    {
        return 0;
    };

    // 更新
    DayWindow.prototype.update = function ()
    {
        Window_Base.prototype.update.call(this);

        if ($gameSystem.isDayWindowVisible())
        {
            this.open();

            if ($gameSystem.shouldDayWindowRefresh())
            {
                this.refresh();
            }

            if (this.x < $gamePlayer.screenX() + 24 && this.x + this._width > $gamePlayer.screenX() - 24 && this.y < $gamePlayer.screenY() && this.y + this._height > $gamePlayer.screenY() - 48)
            {
                this.opacity = 128;
            }
            else
            {
                this.opacity = 255;
            }

            this.contentsOpacity = this.opacity;
        }
        else
        {
            this.close();
        }
    };

    // リフレッシュ
    DayWindow.prototype.refresh = function ()
    {
        this.contents.clear();

        this.contents.fontSize = 28;

        this.changeTextColor(this.normalColor());

        var timeZone;
        switch ($gameVariables.value(82))
        {
            case 0:
                timeZone = "아침";
                break;

            case 1:
                timeZone = "낮";
                break;

            case 2:
                timeZone = "저녁";
                break;

            case 3:
                timeZone = "밤";
                break;
        }
        this.drawText($gameVariables.value(84) + " " + "일 / " + timeZone, 0, 14, this._width, 'center');

        $gameSystem.setShouldDayWindowRefresh(false);
    };

    // シーン マップに追加
    var _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;

    Scene_Map.prototype.createDisplayObjects = function ()
    {
        _Scene_Map_createDisplayObjects.call(this);

        this.createDayWindow();
    };

    Scene_Map.prototype.createDayWindow = function ()
    {
        this._dayWindow = new DayWindow();

        this.addChild(this._dayWindow);
    };

    var _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function ()
    {
        if (!SceneManager.isNextScene(Scene_Battle))
        {
            this._dayWindow.hide();
        }

        _Scene_Map_terminate.call(this);
    };
})();
